#ifndef GST_PARSERS_IMAGE_DATA_HPP
#define GST_PARSERS_IMAGE_DATA_HPP

#include <boost/optional.hpp>

namespace GST
{
namespace Parsers
{
// Image pixel coordinates.
//
// (0, 0) is the upper left corner.
// (pixel-width - 1, pixel-height - 1) is the lower right corner.
struct ImagePixelCoordinate
{
	uint32_t x;
	uint32_t y;
};

// Metadata for an attached image.
//
// * (upper left, lower right) defines the specific area of the image
//   to use when displaying it in the 3D-scene.
// * depth extent, specifies the extent in the depth / z-direction.
// * filename, specifies the name of the image for saving it on the filesystem.
// * Note: The location and extent in (x,y)-direction is defined by the line the
//   image is attached to.
struct AttachedImageMetadata
{
	// The upper left corner in pixel-coordinates.
	// If not set, defaults to (0, 0).
	boost::optional<ImagePixelCoordinate> upperLeft;
	// The lower right corner in pixel-coordinates.
	// If not set, defaults to (pixel-width - 1, pixel-height - 1).
	boost::optional<ImagePixelCoordinate> lowerRight;
	// The depth / z- extent of the image in meters.
	double depthExtent;
	// The filename + extension (without path) the image should be saved under.
	std::string filename;
};

// Metadata and binary data packed together.
struct ImageData
{
	GST::Parsers::AttachedImageMetadata metadata;
	std::vector<uint8_t> binData;
};

} // namespace Parsers
} // namespace GST

#endif // GST_PARSERS_IMAGE_DATA_HPP
